/**
 * @fileoverview 
 * adapter for browser api, control browser actions
 * @author sunnyjiang
 * @version 1.1
 */

var browser = {};

/**
 * switch current tab index to browser page id
 * index + 1 = id
 */
browser.getCurrentPageId = function() {
	var currentTab = tabManager.getCurrentTab();
	return tabManager.getPageIdFromTab(currentTab);

};

/**
 * @namespace tabs
 */
browser.tabs = {};

/**
 * qqbrowser.tabs.home(0)
 */
browser.tabs.home = function() {
    if (qqbrowser) {
        qqbrowser.tabs.home(0);
    }
};

/**
 * remove tab
 */
browser.tabs.remove = function(closeTabIndex) {
	try {
		var pageId = tabManager.getPageIdFromTabIndex(closeTabIndex);
		qqbrowser.tabs.remove(pageId);
	} catch(e) {
	}
};

/**
 * create tab
 */
browser.tabs.create = function(url, fromType) {
	if(!url)
		url = 'about:blank';
	try {
//		var pageId = tabManager.getPageIdFromTabId(tabId);
		qqbrowser.tabs.create(url, fromType, 0);
	} catch(e) {
	}
};

/**
 * лtabʱ
 */
browser.tabs.select = function(tabId) {
//	var index = tabManager.getIndexFromId(tabId);
	var tab = tabManager.getTabFromId(tabId);
	
	if(tab.length != 0) { //  tabʱapi
		try {
			var pageId = tabManager.getPageIdFromTabId(tabId);		

			qqbrowser.tabs.select(pageId);
		} catch(e) {
		}
	}
};

/**
 * tabs switch core
 */
browser.tabs.coreSwitch = function() {
	try {
		qqbrowser.tabs.coreSwitch(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * @namespace page actions
 */
browser.page = {};
/**
 * page go back
 */
browser.page.goBack = function() {
	try {
		qqbrowser.page.goBack(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * page go forward
 */
browser.page.goForward = function() {
	try {
		qqbrowser.page.goForward(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * page reload
 */
browser.page.reload = function() {
	try {	
		qqbrowser.page.reload(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * page stop load
 */
browser.page.stopLoad = function() {
	try {		
		qqbrowser.page.stopLoad(browser.getCurrentPageId());
	} catch(e) {
	}
};

/**
 * page open link
 */
browser.page.navigate = function(url) {
	try {		
		qqbrowser.page.navigate(browser.getCurrentPageId(), url, 0);
	} catch(e) {
	}
};

/**
 * @namespace window actions
 */
browser.window = {};
/**
 * page С
 */
browser.window.minimize = function() {
	try {
		qqbrowser.window.minimize();
	} catch(e) {
	}
};

/**
 * page 
 */
browser.window.maximize = function() {
	try {
		qqbrowser.window.maximize();
	} catch(e) {
	}
};

/**
 * page ر
 */
browser.window.close = function() {
	try {
		qqbrowser.window.close();
	} catch(e) {
	}
};

/**
 * @namespace menu actions
 */
browser.menu = {};
/**
 * APIʱҪһҼ˵
 * @param type ˵ͣ˲ᴫݸmenuҳ
 * @param tabId tabMenuḽtabIdҪ˲ٴmenuҳ棬ԱԸtabв
 * @param parentId ˵IdǶ˵Ϊ-1
 */
browser.menu.popup = function(type, location, tabId, parentId, contentParams) {
	// qqbrowser.menu.popup(obj)
	// nParentId, nTypeId, strUrl, x, y, func, param
	// func: 
	try {
		var menuMap = {mainMenu: 1, logoMenu: 2, contentMenu: 3, tabMenu: 4, toolbarMenu: 5, 
				addressbarMenu: 6, favbarMenu: 7, usefulMenu: 8, 
				logonMenu: 9, usefulSubMenu: 10, tabSubMenu: 11, addressbarBlankMenu: 6};
		var menuParams = {};
		
		menuParams.nParentId = parentId ? parentId : -1; // ûparentIdϲ˵Ϊ-1
		menuParams.nTypeId = menuMap[type] ? menuMap[type] : type; // mapûУΪӲ˵idֱӴ

		// TODO ·
		if(type == 'logoMenu') { // ͷδ¼ʱ
			menuParams.strUrl = 'aero/beforeLoginMenu.html';	
		} else if(type == 'logonMenu') { // ͷҵ¼ʱ
			menuParams.strUrl = 'aero/afterLoginMenu.html';		
		} else if(type == 'addressbarMenu' || type == 'addressbarBlankMenu') { // ַҼ˵
			menuParams.strUrl = 'aero/addressMenu.html';	
		} else { // ˵
			menuParams.strUrl = 'aero/menu.html';
		}

		menuParams.x = location.x;
		menuParams.y = location.y;

		menuParams.returnParams = { // ݸ˵ҳĲ
			'tabId': tabId ? tabId : 0, // ѡǸtabtabҼ˵
			'isTextSelected': type == 'addressbarMenu' ? 1 : 0}; // Ƿѡ֣ڵַҼ˵

		menuParams.contentParams = contentParams ? contentParams : {}; // Ҽ˵ҪĲ

		// functionǲ˵ʱõģݴñ־ȻٵʱǷʾ˵
		menuParams.func = function() {
			
		}

		qqbrowser.menu.popup(menuParams);
	} catch(e) {
		// do nothing
//		alert(e.name + e.message);
	}	
};

/**
 * menuҳʼAPIȡ
 * @param menuId ɵΨһIdmenuҳʱΪݽҳ
 */
browser.menu.init = function(menuId) {
	try {
		qqbrowser.menu.init(menuId, function(menuData) {
			// json stringתΪobject
			menuData = eval('(' + menuData + ')'); 
			
			// ȡõĲ˵鹹, ؿ͸
			return menu.build(menuData);
		});
	} catch(e) {
		// do nothing
//		alert(e.name + e.message);
	}
}

/**
 * ˵¼
 * @param menuId ˵Id
 * @param itemId ˵Id
 */
browser.menu.click = function(menuId, itemId) {
	try {
		qqbrowser.menu.click(menuId, itemId);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

/**
 * @namespace skin actions
 */
browser.skin = {};

//qqbrowser.skin.resize
browser.skin.resize = function(positionInfo) {
	try {
		qqbrowser.skin.resize(positionInfo);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

/**
 * @namespace skin addressbar actions
 */
browser.skin.addressbar = {};

// /triggerInputBeginʱ
//qqbrowser.skin.addressbar.pop(nX, nY, nWidth, nHeight);
browser.skin.addressbar.pop = function(nX, nY, nWidth, nHeight) {
	try {
		qqbrowser.skin.addressbar.pop(nX, nY, nWidth, nHeight);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

// 㵽ַһ֮
//qqbrowser.skin.addressbar.triggerInputBegin();
browser.skin.addressbar.triggerInputBegin = function() {

	try {
		qqbrowser.skin.addressbar.triggerInputBegin();
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

// ÿ뷢
//qqbrowser.skin.addressbar.triggerInputChange(text)
browser.skin.addressbar.triggerInputChange = function(text, inputId) {

	try {
		qqbrowser.skin.addressbar.triggerInputChange(text, inputId);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

// ɵسת
//qqbrowser.skin.addressbar.triggerInputAccept(text)
browser.skin.addressbar.triggerInputAccept = function(text) {
	try {
		qqbrowser.skin.addressbar.triggerInputAccept(text);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

//ҳãȡid
//qqbrowser.skin.addressbar.init(func);
browser.skin.addressbar.init = function(func, func) { 
	try {
		qqbrowser.skin.addressbar.init(func, func);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

// ϺheightΪ0 hide
//qqbrowser.skin.addressbar.adjustHeight
browser.skin.addressbar.adjustHeight = function(addressListheight) {
	try {
		qqbrowser.skin.addressbar.adjustHeight(addressListheight);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

// ɾһ
browser.skin.addressbar.deleteResult = function(extId, itemId) {
	try {
		qqbrowser.skin.addressbar.deleteResult(extId, itemId);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

//skin.addressbar.triggerDroplistShowByClick
browser.skin.addressbar.triggerDroplistShowByClick = function() {
	try {
		qqbrowser.skin.addressbar.triggerDroplistShowByClick();
	} catch(e) {
		// do nothing
//		alert(e.message);
	}
}

//qqbrowser.skin.tab.triggerDragOut(tabId);
browser.skin.tab = {};
browser.skin.tab.triggerDragOut = function(tabId) {
	try {
		qqbrowser.skin.tab.triggerDragOut(tabId);
	} catch(e) {
		// do nothing
//		alert(e.message);
	}	
}

// qqbrowser.skin.buttonClicked(strExtId)
/**
 * ťʱĶ
 */
browser.skin.buttonClicked = function(strExtId) {
	qqbrowser.skin.buttonClicked(strExtId);
}

browser.os = {};
browser.os.windows = {};
//qqbrowser.os.windows.isDwmCompositionEnabled
browser.os.windows.isDwmCompositionEnabled = function() {
	try {
		return qqbrowser.os.windows.isDwmCompositionEnabled();
	} catch(e) {
		return 0;
		// do nothing
//		alert(e.message);
	}
}

browser.popup = {};
browser.popup.create = function() {
	var menuLeft = 0;
	var menuTop = 0;
	// ˵ͳò˵
	var button = $('#fav-button');
	menuLeft = button.offset().left-100;
	menuTop = button.offset().top + button.height()+4;	
	qqbrowser.popup.create(menuLeft, menuTop);
}

//account.getCurrent(fun) fun(obj)obj.nUin strNickName strFacePath strUin 
browser.account = {};
browser.account.getCurrent = function(func) {
	qqbrowser.account.getCurrent(func);
}

/**
 * ղعйصϱ
 */
browser.extension = {};
browser.extension.builtin = {}; 
browser.extension.builtin.statistics = {};
browser.extension.builtin.statistics.increase = function(id) {
	try 
	{
		qqbrowser.extension.builtin.statistics.increase(id);
	} 
	catch(e) 
	{
		
	}
};
